import torch
import time

def main():

    #Create a 1000 by 1000 CPU tensor(matrix) of 1s
    cpu_tensor = torch.ones(1000,1000)

    #Record the current time as start_time
    cpu_start_time = time.time()

    #Every iteration doubles the value of each element in the tensor
    for _ in range(1000000):
        cpu_tensor += cpu_tensor

    #Record the elapsed time (in seconds) as current minus start
    cpu_elapsed_time = time.time() - cpu_start_time

    #Prints the time taken for CPU to compute the 1000 by 1000 tensor of 2^(10^6)
    print(f'\n\nCPU time = {cpu_elapsed_time:.2f} seconds')

    #create a 1000 by 1000 CUDA tensor which uses a GPU for calculation instead
    gpu_tensor = torch.ones(1000,1000).cuda()

    #Repeat the same process
    gpu_start_time = time.time()

    for _ in range(1000000):
        gpu_tensor += gpu_tensor
    
    gpu_elapsed_time = time.time() - gpu_start_time

    print(f'GPU time = {gpu_elapsed_time:.2f} seconds\n\n')

main()